<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\components\Helper;
use common\models\Staffs;
use kartik\daterange\DateRangePicker;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use yii\helpers\Url;
use yii\bootstrap\Modal;
use common\models\Services;
/* @var $this yii\web\View */
/* @var $searchModel common\models\ServicesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Services';
$this->params['breadcrumbs'][] = $this->title;


yii\bootstrap\Modal::begin(['id' =>'modal','header' => 'Add Payment',]);
yii\bootstrap\Modal::end();
$users = Services::getOffices();
?>

<style>
    .modal-body{display: inline-block;}
    .h-auto{height:auto;}
</style>

<div class="services-index">
<p>
<?= Html::a('Create Service', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'service_number',
                    // ['attribute' => 'user_id',
                    //             'value' => 'customer.company',
                    //             'filter' => false
                    // ],
                    [
                        'attribute' => 'user_id',
                        'format' => 'raw',
                        'value' => function($data) {
                        return $data->getOfficeName($data->user_id)['company'];
                        },
                        'filter'=>Html::activeDropDownList($searchModel, 'user_id', $users, ['class' => 'form-control', 'prompt' => 'Select All']), 
//                                
                    ],
                    ['attribute' => 'serial_number',
                        'value' => 'customer.serial_number',
                        'filter' => false
                    ],
                    // 'service_note:ntext',
                    [
                        'attribute' => 'service_type',
                        'format' => 'raw',
                        'value' => function($data) {
                                return $data->service_type;
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'service_type', ["Service" => "Service","Customisation" => "Customisation", "Renewal" => "Renewal", "New Purchase" => "New Purchase"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'service_mode',
                        'format' => 'raw',
                        'value' => function($data) {
                                return $data->service_mode;
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'service_mode', ["AMC" => "AMC", "Paid" => "Paid", "Free" => "Free"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'total_amount',
                        'format' => 'raw',
                        'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                        'value' => function($data) {
                                return $data->total_amount;
                        },
                        // 'filter' => false
                    ],
                    [
                        'attribute' => 'payment_status',
                        'format' => 'raw',
                        'value' => function($data) {
                                if($data->payment_status==1){
                                    return "Paid";
                                }
                                else{
                                    return  Html::a(Yii::t('app', ' {modelClass}', [
                                        'modelClass' => 'Unpaid',
                                        ]), ['services/payment','id'=>$data->id], ['class' => 'btn btn-danger popupModal btn-flat btn-xs']);
                                }
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'payment_status', ["1" => "Paid", "0" => "Un Paid"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'call_type',
                        'format' => 'raw',
                        'visible' => (Yii::$app->user->identity->role ==  User::ROLE_SUPER_ADMIN || User::ROLE_ADMIN ) ? true : false,
                        'value' => function($data) {
                                return $data->call_type;
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'call_type', ["inbound" => "In Bound", "outbound" => "Out Bound"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'attended_by',
                        'format' => 'raw',
                        'visible' => (Yii::$app->user->identity->role ==  User::ROLE_SUPER_ADMIN || User::ROLE_ADMIN ) ? true : false,
                        'value' => function($data) {
                                return Helper::getNameFromID($data->attended_by);
                        },
                       'filter' => Html::activeDropDownList($searchModel, 'attended_by', Staffs::getAllStaffs(), ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'completion_date',
                         'contentOptions' => ['style' => 'width: 225px;'],
                        'format' => 'raw',
                        'value' => function($data) {
                           return $data->completion_date;
                        },
                        'filter' => DateRangePicker::widget([
                        'model' => $searchModel,
                        'name' => 'expiry',
                        'attribute' => 'completion_date',
                        'presetDropdown'=>true,   
                        'hideInput'=>true,
                        'convertFormat'=>true,
                        'pluginOptions' => [
                            'opens'=>'right',
                            'locale' => [
        //                        'cancelLabel' => 'Clear',
                                'format' => 'Y-m-d',
                        ]
                            
                            ],
                    ]),
                    ],
                    'created_at',
                    [
                        'attribute' => 'Days',
                        'format' => 'raw',
                        'value' => function($data) {
                                $firstdate = time();
                                $seconddate = $data->completion_date;
                                $days = Helper::getDaysDiffrence($firstdate, $seconddate);
                                if($data->status !="Completed")
                                {
                                    if($days >1)
                                    {
                                        return  "<span class='btn btn-info btn-flat btn-xs'>".$days." days </span>";  
                                    }
                                    if($days ==1)
                                    {
                                        return   "<span class='btn btn-info btn-flat btn-xs'>".$days." day </span>";  
                                    }
                                    if($days == 0)
                                    {
                                        return   "<span class='btn btn-danger btn-flat btn-xs'>"." Due Today </span>";  
                                    }
                                    if($days < 0)
                                    {
                                        return   "<span class='btn btn-danger btn-flat btn-xs'>"." Overdue </span>";  
                                    }
                                }
                                else{
                                    return   "<span class='btn btn-success btn-flat btn-xs'>"." Completed </span>";
                                }
                                
                                // return  Helper::getDaysDiffrence($firstdate, $seconddate);
                        },
                        'filter' =>false,
                    ],
                    [
                        'attribute' => 'status',
                        'format' => 'raw',
                        'value' => function($data) {
                                return $data->status;
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["Pending" => "Pending", "On Progress" => "On Progress", "Completed" => "Completed", "Cancelled" => "Cancelled"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],

                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)) ? true : false,
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => true,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                                'view' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                                'title' => Yii::t('app', 'customer-view'),
                                    ]);
                                },
                                'update' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                                'title' => Yii::t('app', 'customer-update'),
                                    ]);
                                },
                        ],
                    ],
                ],
            ]); ?>
        </div>
    </div>

</div>
<?php
$this->registerJs("$(function() {
    $('.popupModal').click(function(e) {
      e.preventDefault();
      $('#modal').modal('show')
          .find('.modal-body')
          .load($(this).attr('href'));
    });
 });");
?>

